/*Calculation of the Healthy Eating Index-2010 component and total scores based on data from the 
Diet History Questionnaire (DHQ) and Diet*Calc output

This SAS program can be used to calculate Healthy Eating Index (HEI)-2010 scores from data collected 
using the DHQII in conjunction with the most recent Diet*Calc database, released Dec 2014, that includes 
values from the Food Patterns Equivalents Database (FPED).

This program calculates HEI-2010 component and total scores for each individual, and must be run in
 SAS version 9.4 or higher.  */

									    
*this file should contain the dietcalc results file that used the most recent nutrient database that includes FPED values;
filename in 'results.txt';    *user supplies input file name;

*this file will be created and contains the dietcalc results file with HEI 2010 variables at the end;
filename out 'withhei.results.txt';   *user chooses output file name;

*these are the macros needed to perform the scoring;
%include 'hei2010.beanspeas.allocation.macro.sas';
%include 'hei2010.score.macro.sas';


/*Step 1: Reads in the original Diet*Calc results in two parts:  
First, it reads in the variable names, 
then it reads in the variable values.*/

*input the varible names - some will get jumbled in SAS so this will be used when creating the results file;
options obs=1;
proc import datafile=in 
 out=header
 dbms=csv
 replace;
 getnames=no;
run;

*input the values of the dietcalc results;
options obs=max;
proc import datafile=in
  out=ffq
  dbms=csv
  replace;
  getnames=yes;
run;

/*Step 2: Creates six required variables:  MONOPOLY, FPED_WHOLE_FRT, FPED_V_TOTAL, ALLMEAT, SEAPLANT and EMPTYCAL10.*/
data ffq;
  set ffq;

monopoly=(TOTAL_MONOUNSAT_FA_G_USDA+TOTAL_POLYUNSAT_FA_G_USDA);

fped_whole_frt=sum(FPED_F_CITMLB_CP_EQUIV_USDA,FPED_F_OTHER_CP_EQUIV_USDA);
fped_v_total=FPED_V_TOTAL_CP_EQUIV_USDA;    *the fped name is too long and will crash the macro, so rename;

ALLMEAT=FPED_PF_MPS_TOTAL_OZ_EQUIV_USDA+FPED_PF_EGGS_OZ_EQUIV_USDA+FPED_PF_NUTSDS_OZ_EQUIV_USDA+FPED_PF_SOY_OZ_EQUIV_USDA; 
SEAPLANT=FPED_PF_SEAFD_HI_OZ_EQUIV_USDA+FPED_PF_SEAFD_LOW_OZ_EQUIV_USDA+FPED_PF_SOY_OZ_EQUIV_USDA+FPED_PF_NUTSDS_OZ_EQUIV_USDA; 

/**Calculate intake of Calories from SoFAAS**/

ADDSUGC=16*FPED_ADD_SUGARS_TSP_EQUIV_USDA; /*calories from added sugars*/
SOLFATC=FPED_SOLID_FATS_G_EQUIV_USDA*9; /*calories from solid fat*/

maxalcgr=13*(ENERGY_KCAL_USDA/1000); /*max grams of alcohol based on kcal intake*/

if ALCOHOL_G_USDA <= maxalcgr then EXALCCAL=0; /*consumed less than max*/
else if ALCOHOL_G_USDA > maxalcgr then EXALCCAL=7*(ALCOHOL_G_USDA-maxalcgr); /*get cal from extra alc grams*/

EMPTYCAL10=ADDSUGC+SOLFATC+EXALCCAL; /*total empty calories in hei2010 definition*/

                 

Run;


/*Step 3. Runs the macro to properly allocate the intakes of the FPED variable Legumes  */
%LEG2010A (indat=ffq,
kcal=ENERGY_KCAL_USDA,
allmeat=allmeat,
seaplant=seaplant,
v_total=fped_v_total,
v_drkgr=FPED_V_DRKGR_CP_EQUIV_USDA,
legumes=FPED_V_LEGUMES_CP_EQUIV_USDA,
outdat=aftlegall);

run;

/*Step 4. Runs the HEI-2010 scoring macro which calculates intake density amounts and HEI scores  */ 

%HEI2010 (indat=aftlegall,
kcal=ENERGY_KCAL_USDA,
lv_total=legume_added_fped_v_total,
lbeangrn=legume_added_BEANGRN,
f_total=FPED_F_TOTAL_CP_EQUIV_USDA,
wholefrt=fped_whole_frt,
g_whl=FPED_G_WHOLE_OZ_EQUIV_USDA,
d_total=FPED_D_TOTAL_CP_EQUIV_USDA,
lallmeat=legume_added_ALLMEAT,
lseaplant=legume_added_SEAPLANT,
monopoly=monopoly,
sfat=TOTAL_SAT_FA_G_USDA ,
sodi=SODIUM_MG_USDA,
G_NWHL=FPED_G_REFINED_OZ_EQUIV_USDA,
EMPTYCAL10=EMPTYCAL10,
outdat=aftermac);

run;

/*Step 5.Saves the results for each individual in a comma delimited text file with a name provided by the user
 that ends: withhei.results.txt*/
data complete;
  set header aftermac;
run;

proc contents varnum;
run;

data _null_;
  set complete;
  file out lrecl=7000 DLM=',';	
  format  VEGDEN	 
GRBNDEN 
FRTDEN	
WHFRDEN 
RGDEN  
WGRNDEN	 
DAIRYDEN  
MEATDEN 
SEAPLDEN  
FARATIO 
SODDEN	
SOFA_PERC    
HEI2010_TOTAL_SCORE  HEIX1_TOTALVEG  HEIX2_GREEN_AND_BEAN  HEIX3_TOTALFRUIT HEIX4_WHOLEFRUIT 
  HEIX11_REFINEDGRAIN  HEIX5_WHOLEGRAIN  HEIX6_TOTALDAIRY  HEIX7_TOTPROT  HEIX8_SEAPLANT_PROT 
  HEIX9_FATTYACID HEIX10_SODIUM  HEIX12_SOFAAS f8.2;
  *put one line of variable names;     
  if _n_=1 then put var1-var259 
  'TOT_VEG_FPED_DEN,'
'DRK_GRN_BEAN_FPED_DEN,'
'TOT_FRUIT_FPED_DEN,'
'WHOLE_FRUIT_FPED_DEN,'
'REFINED_GRAIN_FPED_DEN,'
'WHOLE_GRAIN_FPED_DEN,'
'TOT_DAIRY_FPED_DEN,'
'TOT_MEAT_PRO_FD_FPED_DEN,'
'SEA_FD_PLANT_PRO_FPED_DEN,'
'FATTY_ACID RATIO,'
'SODIUM_DEN,'
'PCT_EMPTY_KCAL,'
    'HEI2010_TOTAL_SCORE,'
'HEI2010_COMP_TOT_VEG,'
'HEI2010_COMP_DRK_GRN_BEAN,'
'HEI2010_COMP_TOT_FRUIT,'
'HEI2010_COMP_WHOLE_FRUIT,'
'HEI2010_COMP_REFINED_GRAIN,'
'HEI2010_COMP_WHOLE_GRAIN,'
'HEI2010_COMP_TOT_DAIRY,'
'HEI2010_COMP_TOT_MEAT_PRO_FD,'
'HEI2010_COMP_SEA_FD_PLANT_PRO,'
'HEI2010_COMP_FATTY_ACID,' 
'HEI2010_COMP_SODIUM,'
'HEI2010_COMP_EMPTY_KCAL'
;  
   *put values of all variables plus hei 2010 score info;
   else put Respondent_ID--Vegetables_for_adjust__Flag 
   	 VEGDEN	 
GRBNDEN 
FRTDEN	
WHFRDEN 
RGDEN  
WGRNDEN	 
DAIRYDEN  
MEATDEN 
SEAPLDEN  
FARATIO 
SODDEN	
SOFA_PERC 

  HEI2010_TOTAL_SCORE  HEIX1_TOTALVEG  HEIX2_GREEN_AND_BEAN  HEIX3_TOTALFRUIT  HEIX4_WHOLEFRUIT 
  HEIX11_REFINEDGRAIN  HEIX5_WHOLEGRAIN  HEIX6_TOTALDAIRY  HEIX7_TOTPROT  HEIX8_SEAPLANT_PROT  
  HEIX9_FATTYACID HEIX10_SODIUM  HEIX12_SOFAAS  
  ; 
run;

